import form1
import qt


class ItemGUI(form1.Form1):
    def __init__(self, ITEM=None, parent=None, name=None, fl=0):
        form1.Form1.__init__(self,parent, name, fl)
        self.ITEM=ITEM

        #ridimensione il textedit
        if(type(self.ITEM.len)==type(1)):
            lung = self.ITEM.len
        else:
            lung = self.ITEM.len[1]
            
        self.lineEdit1.setMaxLength( lung )
        self.lineEdit1.setFixedWidth(self.lineEdit1.fontMetrics().width('#' * (lung+1) ))
        self.setFocusPolicy(qt.QWidget.StrongFocus)

        # metti il nome
        
        self.textLabel1.setText(self.ITEM.nome)



        # carica il combobox delle scelte

        scelte=self.ITEM.scelte

        self.dizio_scelte={}
        self.dizio_combo={}
        count=0
        for key in scelte.keys():
            val=scelte[key]
            self.dizio_scelte[key]=count
            self.dizio_combo[count]=key
            count+=1
            self.comboBox1.insertItem (key+"|||"+val  )
        
        # metti il valore
        
        self.aggiornaDisplayed()
        

    def aggiornaDisplayed(self):
        testo=self.ITEM.getTesto()
        print " metto testo ", testo
        self.lineEdit1.setText(testo)
        self.aggiornaCombo()
        
    def lineEdit1_textChanged(self,a0):
        token=str(a0)
        print " ricevuto ", token
        self.ITEM.setta(token)
        self.aggiornaCombo()


    def aggiornaCombo(self):
        scelta=self.ITEM.cercaScelta()
        if(scelta[0] is None ):
            key=scelta[1]
            val=scelta[2]
            good=0
        else:
            key=scelta[0]
            val=scelta[1]
            good=1
            index=self.dizio_scelte[key]
            self.comboBox1.setCurrentItem(index)
        self.validaCombo()


    def comboBox1_activated(self):
        self.validaCombo()
        




    def validaCombo(self):
        index = self.comboBox1.currentItem()
        keyC = self.dizio_combo[index]
        valid = self.ITEM.ceccaCond(keyC)
        print " valid ", valid
        if(valid):
            self.comboBox1.setPaletteBackgroundColor(qt.QColor(134,255,53))
        else:
            self.comboBox1.setPaletteBackgroundColor(qt.QColor(255,134,53))
            
        self.emit(qt.PYSIGNAL("item_maybe_changed"),(self,))

    def focusInEvent(self, ev):
        print " ricevuto il focus "
        self.emit(qt.PYSIGNAL("focus_qui"),(self,))


 
class mainWindow(qt.QSplitter):


    def __init__(self, items, parent):

        qt.QSplitter.__init__(self, parent)
        self.setOrientation( qt.Qt.Vertical )
        
        sv       =  qt.QScrollView(self)
        self.ledoc    =  qt.QTextEdit  (self)
        self.leinput  =  qt.QTextEdit  (self)
        self.connect(self.leinput, qt.SIGNAL("clicked(int,int)"), self.CLickedOnInput)
        self.connect(self.ledoc  , qt.SIGNAL("clicked(int,int)"), self.CLickedOnDoc  )

        

        H=0
        self.obList=[]
        for iITEM in range(len( items )):
            ob=ItemGUI(parent = sv.viewport(), ITEM=items[iITEM])
            self.obList.append(ob)
            sv.addChild(ob,0,H)
            H=H+ob.height()
            ob.connect(ob,qt.PYSIGNAL("item_maybe_changed"), self.aggiornaLinea    )
            ob.connect(ob,qt.PYSIGNAL("item_maybe_changed"), self.aggiornaCommento )
            ob.connect(ob,qt.PYSIGNAL("focus_qui"         ), self.aggiornaCommento )
        
        sv.resizeContents(  ob.width(), H+ ob.height() )
        self.ledoc.setReadOnly(1)
        self.leinput.setReadOnly(1)
        self.resize ( ob.width()+20 , 400 )

        self.sv=sv
        self.items=items

    def CLickedOnInput(self, para, pos):
        nitem=0
        postot=0
        posy=0
        testo=self.leinput.text()
        leniniz = len(testo)
        for item in self.items:
            testo=item.estrai(testo , setta=0 )
            
            #  postot=postot+item.len
            dh=self.obList[nitem].height()
            dw=self.obList[nitem].width()
            posy=posy+dh
            if(len(testo)< leniniz-pos):
                break
##            if(postot>pos):
##                break
            nitem+=1
        self.sv.center( 0,posy-dh/2  )
        self.aggiornaCommento(self.obList[nitem])
        self.obList[nitem].lineEdit1.setFocus()

        
        print " on input "
        print " para ", para
        print " pos " , pos
        
    def CLickedOnDoc  (self, para, pos):
        return
        print " on doc  "
        print " para ", para
        print " pos " , pos

    def aggiornaLinea(self, dum=None):
        s=""
        for ob in self.obList:
            s=s+ob.ITEM.getTesto()
        self.leinput.setText(s)
        
    def aggiornaCommento(self, ob):
        s=ob.comboBox1.currentText()
        self.ledoc.setText(s)

      
    def aggiornaAllItems(self,):
        for ob in self.obList:
            ob.aggiornaDisplayed()
        
